# PhoenixPE

[![Latest Release](https://img.shields.io/github/release-pre/phoenixpe/phoenixpe.svg?style=flat-square&label=Latest%20Release)](https://github.com/phoenixpe/phoenixpe/releases)
[![License](https://img.shields.io/badge/license-MIT-blue.svg?style=flat-square&label=License)](https://opensource.org/licenses/MIT)
[![Download Stats](https://img.shields.io/github/downloads/phoenixpe/phoenixpe/total.svg?label=Downloads&style=flat-square)](https://github.com/phoenixpe/phoenixpe/releases)
[![Contributors](https://img.shields.io/github/contributors/phoenixpe/phoenixpe.svg?style=flat-square&label=Contributors)](https://github.com/phoenixpe/phoenixpe/graphs/contributors)

![PhoenixPE Logo](https://github.com/PhoenixPE/PhoenixPE/blob/master/.github/Images/PhoenixPE.png)

PhoenixPE is a WinPE Rescue/Recovery Environment based on Win10/Win11. It can be booted via USB, CD/DVD, PXE/Network, or hard disk.

* PhoenixPE uses the "next-generation" [PEBakery](https://github.com/pebakery/PEBakery) engine resulting in faster build times and advanced features compared to legacy Winbuilder projects.
* Build from Win10/Win11 sources using either boot.wim or WinRE.wim as a base.
* Designed from the ground up to be developer/contributor friendly and use clean, well documented code.
* Easy to understand options and uncluttered user interface.
* Flexible architecture.
* PEBakery's powerful scripting language allows extensive customization.

## Features

* Drive Backup/Clone/Imaging
* Malware Removal
* Password Recovery
* File Recovery
* Forensics Tools
* Drive Partitioning/Install Prep.
* Hardware Diagnostics
* Offline OS Troubleshooting/Repair/Recovery
* And more...

PhoenixPE includes a variety of carefully selected applications to get you started and PEBakery's user friendly scripting language makes it easy for you create your own scripts and customize PhoenixePE with your favorite apps and settings.

![PhoenixPE Logo](https://github.com/PhoenixPE/PhoenixPE/blob/master/.github/Images/PhoenixPE-Main.png)

![PhoenixPE Logo](https://github.com/PhoenixPE/PhoenixPE/blob/master/.github/Images/PhoenixPE-Win11-01.png)

## License

**PhoenixPE** is licensed under the MIT license. Refer to [license](LICENSE) for more information.

## Installation

Download the [latest release](https://github.com/PhoenixPE/PhoenixPE/releases) and unpack it in the desired location. To uninstall, simply delete the PhoenixPE folder.

## Documentation

Documentation is available on the [PhoenixPE Wiki](https://github.com/PhoenixPE/PhoenixPE/wiki).

## Development

PhoenixPE is developed, maintained, and supported by a community of developers/volunteers who enjoy sharing their ideas and work in their free time. 

Interested in contributing to PhoenixPE? Please read our [contributor guidelines](https://github.com/PhoenixPE/PhoenixPE/blob/master/docs/CONTRIBUTING.md).

Want to create your own scripts, include additional applications, and personalize PhoenixPE to your taste?

Check out the following resources:
* [PEBakery Documentation](https://github.com/pebakery/pebakery-docs)
* [PhoenixPE API](https://github.com/PhoenixPE/PhoenixPE/wiki/PhoenixAPI)

## Enhancements/Bugs

Please use the [GitHub issue tracker](https://github.com/PhoenixPE/PhoenixPE/issues) for reporting problems or suggesting new features.

## Support

PhoenixPE is supported by a vibrant community of developers, boot disk/WinPE enthusiasts, and volunteers. Please post general questions and support requests in one of our forums.

* [The Oven](https://theoven.org/viewforum.php?f=26)

## Frequently Asked Questions (FAQ)

Please check out our [Frequently Asked Questions](https://github.com/PhoenixPE/PhoenixPE/wiki/FAQ) before posting an issue or asking for help in the forums.

We also ask that you take the time to read our statement on [Security](https://github.com/PhoenixPE/PhoenixPE/wiki/Security) and [Antivirus False Positives](https://github.com/PhoenixPE/PhoenixPE/wiki/Security).
